package com.ibm.lab.soln.junit.money;
import junit.framework.*;
public class MoneyTest extends TestCase {
	private Money f12CHF;
	private Money f14CHF;
	private Money f7USD;
	private Money f21USD;
	public MoneyTest(String name) {
		super(name);
	}
	protected void setUp() {
		f12CHF= new Money(12, "CHF");
		f14CHF= new Money(14, "CHF");
	}
	public void testSimpleAdd() {
		// [12 CHF] + [14 CHF] == [26 CHF]
		Money expected= new Money(26, "CHF");
		assertEquals(expected, f12CHF.add(f14CHF));
	}
	public void testSimpleMultiply() {
		// [14 CHF] *2 == [28 CHF]
		Money expected= new Money(28, "CHF");
		assertEquals(expected, f14CHF.multiply(2));
	}
	public void testSimpleSubtract() {
		// [14 CHF] - [12 CHF] == [2 CHF]
		Money expected= new Money(2, "CHF");
		assertEquals(expected, f14CHF.subtract(f12CHF));
	}
}